/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rudolph.peers;

import com.acunia.wonka.rudolph.peers.DefaultComponent;
import com.acunia.wonka.rudolph.peers.RudolphPeer;
import com.acunia.wonka.rudolph.peers.RudolphScrollbarPeer;
import com.acunia.wonka.rudolph.peers.ScrollPainter;
import com.acunia.wonka.rudolph.peers.ScrollRunner;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.event.AdjustmentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.peer.ScrollbarPeer;

public class DefaultScrollbar
extends DefaultComponent
implements ScrollbarPeer,
MouseListener,
MouseMotionListener {
    private ScrollPainter thePainter;
    private Point lastMousePosition;
    static final ScrollRunner mouseEventRunner = new ScrollRunner();
    private Image backgroundImage;
    private Graphics backgroundGraphics;
    private int scrollbarMinimum;

    public DefaultScrollbar(Scrollbar scrollbar) {
        super(scrollbar);
        scrollbar.addMouseListener(this);
        scrollbar.addMouseMotionListener(this);
        this.lastMousePosition = new Point(0, 0);
        this.backgroundImage = null;
        this.backgroundGraphics = null;
    }

    private void buildScrollbar() {
        Scrollbar scrollbar = (Scrollbar)this.component;
        this.thePainter = scrollbar.getOrientation() == 0 ? new HScrollPainter() : new VScrollPainter();
        int value = scrollbar.getValue();
        int minimum = scrollbar.getMinimum();
        int maximum = scrollbar.getMaximum();
        int visible = scrollbar.getVisible();
        this.thePainter.setBarValues(value - minimum, visible, maximum - minimum);
        this.thePainter.setBarColors(RudolphPeer.getBarColors());
    }

    public void setLineIncrement(int increment) {
        if (this.thePainter == null) {
            this.buildScrollbar();
        }
        this.thePainter.setLineStep(increment);
    }

    public void setPageIncrement(int increment) {
        if (this.thePainter == null) {
            this.buildScrollbar();
        }
        this.thePainter.setBlockStep(increment);
    }

    public void setValues(int value, int visible, int minimum, int maximum) {
        if (this.thePainter == null) {
            this.buildScrollbar();
        }
        if (maximum > minimum) {
            this.scrollbarMinimum = minimum;
            this.thePainter.setBarValues(value - minimum, visible, maximum - minimum);
        } else {
            this.scrollbarMinimum = maximum;
            this.thePainter.setBarValues(value - maximum, visible, minimum - maximum);
        }
        this.paint(this.getGraphics());
    }

    public Dimension getMinimumSize() {
        if (this.thePainter == null) {
            this.buildScrollbar();
        }
        return this.thePainter.getMinimumSize();
    }

    public Dimension getPreferredSize() {
        if (this.thePainter == null) {
            this.buildScrollbar();
        }
        return this.thePainter.getPreferredSize(this.component.getSize().width, this.component.getSize().height);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        int active;
        if (this.thePainter == null) {
            this.buildScrollbar();
        }
        if ((active = this.thePainter.setActive(e.getX(), e.getY())) == 2 && this.thePainter.lineUp()) {
            this.processAdjustmentEvent(2);
            mouseEventRunner.setRunner(this.thePainter, this.component);
        } else if (active == 1 && this.thePainter.lineDn()) {
            this.processAdjustmentEvent(1);
            mouseEventRunner.setRunner(this.thePainter, this.component);
        } else if (active == 3 && this.thePainter.pageUp()) {
            this.processAdjustmentEvent(3);
            mouseEventRunner.setRunner(this.thePainter, this.component);
        } else if (active == 4 && this.thePainter.pageDn()) {
            this.processAdjustmentEvent(4);
            mouseEventRunner.setRunner(this.thePainter, this.component);
        } else if (active == 5) {
            this.lastMousePosition.setLocation(e.getX(), e.getY());
        }
        this.paint(this.getGraphics());
    }

    public void mouseReleased(MouseEvent e) {
        if (this.thePainter == null) {
            this.buildScrollbar();
        }
        if (this.thePainter.isSelected()) {
            mouseEventRunner.stopRunner(this.thePainter);
        }
        this.paint(this.getGraphics());
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        if (this.thePainter == null) {
            this.buildScrollbar();
        }
        if (this.thePainter.isSelected()) {
            mouseEventRunner.stopRunner(this.thePainter);
            this.paint(this.getGraphics());
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.thePainter == null) {
            this.buildScrollbar();
        }
        if (this.thePainter.getActive() == 5) {
            if (this.thePainter.moveScreenPos(e.getX() - this.lastMousePosition.x, e.getY() - this.lastMousePosition.y)) {
                this.processAdjustmentEvent(5);
            } else if (this.thePainter.setActive(e.getX(), e.getY()) != 5) {
                this.thePainter.setNoSelected();
                this.paint(this.getGraphics());
            }
            this.lastMousePosition.setLocation(e.getX(), e.getY());
        }
        this.paint(this.getGraphics());
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void paint(Graphics g) {
        SystemColor font;
        if (g == null) {
            return;
        }
        if (this.thePainter == null) {
            this.buildScrollbar();
        }
        if (this.backgroundImage == null || !this.component.getSize().equals(this.thePainter.getCurrentSize())) {
            this.thePainter.setRange(this.component.getSize().width, this.component.getSize().height);
            this.thePainter.setThickness(this.component.getSize().width, this.component.getSize().height);
            this.backgroundImage = this.createImage(this.component.getSize().width, this.component.getSize().height);
            if (this.backgroundImage != null && this.backgroundGraphics != null) {
                this.backgroundGraphics.dispose();
            }
            this.backgroundGraphics = this.backgroundImage.getGraphics();
        }
        SystemColor back = this.component.getBackground() != null ? this.component.getBackground() : SystemColor.scrollbar;
        Color color = font = this.component.getForeground() != null ? this.component.getForeground() : SystemColor.menuText;
        if (!back.equals(this.thePainter.getBackground()) || !font.equals(this.thePainter.getForeground())) {
            this.thePainter.setBarColors(this.component.getBackground(), this.component.getForeground());
        }
        this.thePainter.paint(this.backgroundGraphics);
        g.drawImage(this.backgroundImage, 0, 0, this.component);
    }

    public void processAdjustmentEvent(int type) {
        AdjustmentEvent e = new AdjustmentEvent((Adjustable)((Object)this.component), 601, type, this.thePainter.getBarPos() + this.scrollbarMinimum);
        this.component.dispatchEvent(e);
        this.paint(this.getGraphics());
    }

    public void setBackground(Color c) {
        if (this.thePainter == null) {
            this.buildScrollbar();
        }
        super.setBackground(c);
        this.thePainter.setBarColors(c, this.component.getForeground());
    }

    public void setForeground(Color c) {
        if (this.thePainter == null) {
            this.buildScrollbar();
        }
        super.setForeground(c);
        this.thePainter.setBarColors(this.component.getBackground(), c);
    }

    class VScrollPainter
    extends ScrollPainter {
        public VScrollPainter() {
            super(16, 16, 16, 16);
        }

        public int getPos(int x, int y) {
            return y;
        }

        public int getThickness(int width, int height) {
            return width;
        }

        public Dimension getSize(int scrollbarlength, int scrollbarthickness) {
            return new Dimension(scrollbarthickness, scrollbarlength);
        }

        public Dimension getPreferredSize(int width, int height) {
            return new Dimension(this.minimumThickness, height);
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.minimumThickness, this.lineUpSpan + this.lineDnSpan + this.minimumScreenSpan);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.minimumThickness, this.lineUpSpan + this.lineDnSpan + this.screenRange);
        }

        public Dimension getCurrentSize() {
            return new Dimension(this.currentThickness, this.lineUpSpan + this.lineDnSpan + this.screenRange);
        }

        public void setThickness(int width, int height) {
            this.currentThickness = width > this.minimumThickness ? width : this.minimumThickness;
        }

        public boolean setRange(int width, int height) {
            return this.setRange(height);
        }

        public int getField(int x, int y) {
            return this.getField(y);
        }

        public synchronized int setActive(int x, int y) {
            this.currentActive = this.getField(y);
            return this.currentActive;
        }

        public boolean moveScreenPos(int dx, int dy) {
            return dy != 0 ? this.moveBar(dy) : false;
        }

        public void paint(Graphics g) {
            if (this.crippledSpan < 0) {
                RudolphScrollbarPeer.paintVScrollbar(0, 0, this.currentThickness, this.paintedScreenPos, this.screenSpan, this.screenRange, this.currentActive, this.barColors, g);
            } else {
                RudolphScrollbarPeer.paintCrippledVScrollbar(0, 0, this.currentThickness, this.crippledSpan, this.currentActive, this.barColors, g);
            }
        }
    }

    class HScrollPainter
    extends ScrollPainter {
        public HScrollPainter() {
            super(16, 16, 16, 16);
        }

        public int getPos(int x, int y) {
            return x;
        }

        public int getThickness(int width, int height) {
            return height;
        }

        public Dimension getSize(int scrollbarlength, int scrollbarthickness) {
            return new Dimension(scrollbarlength, scrollbarthickness);
        }

        public Dimension getPreferredSize(int width, int height) {
            return new Dimension(width, this.minimumThickness);
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.lineUpSpan + this.lineDnSpan + this.minimumScreenSpan, this.minimumThickness);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.lineUpSpan + this.lineDnSpan + this.screenRange, this.minimumThickness);
        }

        public Dimension getCurrentSize() {
            return new Dimension(this.lineUpSpan + this.lineDnSpan + this.screenRange, this.currentThickness);
        }

        public void setThickness(int width, int height) {
            this.currentThickness = height > this.minimumThickness ? height : this.minimumThickness;
        }

        public boolean setRange(int width, int height) {
            return this.setRange(width);
        }

        public int getField(int x, int y) {
            return this.getField(x);
        }

        public synchronized int setActive(int x, int y) {
            this.currentActive = this.getField(x);
            return this.currentActive;
        }

        public boolean moveScreenPos(int dx, int dy) {
            return dx != 0 ? this.moveBar(dx) : false;
        }

        public void paint(Graphics g) {
            if (this.crippledSpan < 0) {
                RudolphScrollbarPeer.paintHScrollbar(0, 0, this.currentThickness, this.paintedScreenPos, this.screenSpan, this.screenRange, this.currentActive, this.barColors, g);
            } else {
                RudolphScrollbarPeer.paintCrippledHScrollbar(0, 0, this.currentThickness, this.crippledSpan, this.currentActive, this.barColors, g);
            }
        }
    }
}

