/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rudolph.peers;

import com.acunia.wonka.rudolph.peers.DefaultComponent;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.SystemColor;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.peer.CheckboxPeer;

public class DefaultCheckbox
extends DefaultComponent
implements CheckboxPeer,
MouseListener {
    private CheckboxGroup group;
    private String label;
    private boolean state;

    public DefaultCheckbox(Checkbox checkbox) {
        super(checkbox);
        checkbox.addMouseListener(this);
    }

    private native void createPeer();

    public void setCheckboxGroup(CheckboxGroup group) {
        this.group = group;
        this.paint(this.getGraphics());
    }

    public void setLabel(String label) {
        this.label = label;
        this.paint(this.getGraphics());
    }

    public void setState(boolean state) {
        this.state = state;
        this.paint(this.getGraphics());
    }

    public Dimension getPreferredSize() {
        Checkbox checkbox = (Checkbox)this.component;
        FontMetrics fm = this.getFontMetrics(checkbox.getFont() != null ? checkbox.getFont() : Component.DEFAULT_FONT);
        int cx = Math.max(60, 30 + fm.stringWidth(checkbox.getLabel()));
        int cy = Math.max(20, 2 * fm.getHeight());
        return new Dimension(cx, cy);
    }

    public void paint(Graphics g) {
        if (g == null) {
            return;
        }
        int checkboxsize = 12;
        Dimension size = this.component.getSize();
        Font f = this.component.getFont();
        FontMetrics fm = this.getFontMetrics(f != null ? f : Component.DEFAULT_FONT);
        if (!this.component.isEnabled()) {
            g.setColor(SystemColor.textInactiveText);
        }
        g.drawString(this.label, checkboxsize + 5, (size.height - fm.getHeight()) / 2 + fm.getAscent());
        int y = (size.height - checkboxsize) / 2;
        if (this.group != null) {
            g.setColor(Color.white);
            g.fillOval(1, y + 1, checkboxsize - 2, checkboxsize - 2);
            g.setColor(Color.black);
            g.drawOval(1, y + 1, checkboxsize - 2, checkboxsize - 2);
            if (this.state) {
                g.fillOval(4, y + 4, checkboxsize - 8, checkboxsize - 8);
                g.drawOval(4, y + 4, checkboxsize - 8, checkboxsize - 8);
            }
        } else {
            if (this.state) {
                g.setColor(SystemColor.controlShadow);
            } else {
                g.setColor(SystemColor.controlHighlight);
            }
            g.drawLine(0, y, checkboxsize - 1, y);
            g.drawLine(0, y, 0, y + checkboxsize - 1);
            g.drawLine(1, y + 1, checkboxsize - 2, y + 1);
            g.drawLine(1, y + 1, 1, y + checkboxsize - 2);
            if (this.state) {
                g.setColor(SystemColor.controlHighlight);
            } else {
                g.setColor(SystemColor.controlShadow);
            }
            g.drawLine(0, y + checkboxsize - 1, checkboxsize - 1, y + checkboxsize - 1);
            g.drawLine(checkboxsize - 1, y, checkboxsize - 1, y + checkboxsize - 1);
            g.drawLine(1, y + checkboxsize - 2, checkboxsize - 2, y + checkboxsize - 2);
            g.drawLine(checkboxsize - 2, y + 1, checkboxsize - 2, y + checkboxsize - 2);
            if (this.state) {
                g.setColor(SystemColor.control.darker());
            } else {
                g.setColor(SystemColor.control);
            }
            g.fillRect(2, y + 2, checkboxsize - 4, checkboxsize - 4);
        }
        super.paint(g);
    }

    public void mousePressed(MouseEvent me) {
        if (this.group != null) {
            this.group.setSelectedCheckbox((Checkbox)this.component);
        } else {
            ((Checkbox)this.component).setState(!this.state);
        }
        this.component.dispatchEvent(new ItemEvent((ItemSelectable)((Object)this.component), 701, this.label, this.state ? 1 : 2));
    }

    public void mouseClicked(MouseEvent me) {
    }

    public void mouseReleased(MouseEvent me) {
    }

    public void mouseEntered(MouseEvent me) {
    }

    public void mouseExited(MouseEvent me) {
    }
}

