/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rudolph;

import com.acunia.wonka.rudolph.DecorationWindow;
import com.acunia.wonka.rudolph.Dispatcher;
import com.acunia.wonka.rudolph.Painter;
import com.acunia.wonka.rudolph.TitleWindow;
import com.acunia.wonka.rudolph.Toolkit;
import com.acunia.wonka.rudolph.peers.DefaultMenuBar;
import com.acunia.wonka.rudolph.peers.MenuWindow;
import com.acunia.wonka.rudolph.taskbar.TaskBar;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Vector;
import java.util.WeakHashMap;

public class WindowManager {
    private static WindowManager wm = null;
    private Vector windowList = new Vector();
    private WeakHashMap decorations = new WeakHashMap();
    private WeakHashMap menubars = new WeakHashMap();

    public static WindowManager getInstance() {
        if (wm == null) {
            wm = new WindowManager();
        }
        return wm;
    }

    private WindowManager() {
    }

    public Rectangle checkBounds(Window win, int x, int y, int w, int h) {
        if (win instanceof DecorationWindow || win instanceof MenuWindow) {
            return new Rectangle(x, y, w, h);
        }
        if (!(win instanceof TaskBar)) {
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            int tl = TaskBar.getBarLocation();
            if (tl != 4) {
                int trig;
                int ts = TaskBar.getBarSize();
                int ttop = tl == 1 ? ts : 0;
                int tbot = tl == 0 ? ts : 0;
                int tlef = tl == 2 ? ts : 0;
                int n = trig = tl == 3 ? ts : 0;
                if (x < tlef) {
                    x = tlef;
                }
                if (y < ttop) {
                    y = ttop;
                }
                if (x + w > screen.width - trig) {
                    w = screen.width - x - trig;
                }
                if (y + h > screen.height - tbot) {
                    h = screen.height - y - tbot;
                }
            }
        }
        return this.updateWindow(win, x, y, w, h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisible(Window win, boolean visible) {
        if (!(win instanceof DecorationWindow) && !(win instanceof MenuWindow)) {
            Object object = win.getTreeLock();
            synchronized (object) {
                DefaultMenuBar menubar;
                Decoration decoration = (Decoration)this.decorations.get(win);
                if (decoration != null) {
                    decoration.top.setVisible(visible);
                    decoration.bottom.setVisible(visible);
                    decoration.left.setVisible(visible);
                    decoration.right.setVisible(visible);
                }
                if ((menubar = (DefaultMenuBar)this.menubars.get(win)) != null) {
                    menubar.getBarWindow().setVisible(visible);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toBack(Window win) {
        if (!(win instanceof DecorationWindow) && !(win instanceof MenuWindow)) {
            Object object = win.getTreeLock();
            synchronized (object) {
                DefaultMenuBar menubar;
                Decoration decoration = (Decoration)this.decorations.get(win);
                if (decoration != null) {
                    decoration.top.toBack();
                    decoration.bottom.toBack();
                    decoration.left.toBack();
                    decoration.right.toBack();
                }
                if ((menubar = (DefaultMenuBar)this.menubars.get(win)) != null) {
                    menubar.getBarWindow().toBack();
                }
            }
        }
    }

    public void setTitle(Window win, String title) {
        Decoration decoration = (Decoration)this.decorations.get(win);
        if (decoration != null) {
            decoration.top.setTitle(title);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toFront(Window win) {
        if (!(win instanceof DecorationWindow) && !(win instanceof MenuWindow)) {
            Object object = win.getTreeLock();
            synchronized (object) {
                DefaultMenuBar menubar;
                Decoration decoration = (Decoration)this.decorations.get(win);
                if (decoration != null) {
                    decoration.top.toFront();
                    decoration.bottom.toFront();
                    decoration.left.toFront();
                    decoration.right.toFront();
                }
                if ((menubar = (DefaultMenuBar)this.menubars.get(win)) != null) {
                    menubar.getBarWindow().toFront();
                }
            }
        }
        if (!(win instanceof TaskBar) && TaskBar.getTaskBar() != null) {
            TaskBar.getTaskBar().toFront();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWindow(Window win) {
        if (win instanceof DecorationWindow || win instanceof MenuWindow) {
            return;
        }
        if (!(win instanceof TaskBar)) {
            Object object = win.getTreeLock();
            synchronized (object) {
                TaskBar.getTaskBar();
                if (this.windowList.size() == 0) {
                    Dispatcher.getMainDispatcher().start();
                    Painter.getInstance().start();
                }
                if (win instanceof Frame) {
                    this.windowList.add(win);
                }
                if (win instanceof Dialog || win instanceof Frame) {
                    this.addWindowDecorations(win);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWindow(Window win) {
        if (win instanceof DecorationWindow || win instanceof MenuWindow) {
            return;
        }
        if (!(win instanceof TaskBar)) {
            Object object = win.getTreeLock();
            synchronized (object) {
                if (this.windowList.size() == 0) {
                    Dispatcher.getMainDispatcher().stop();
                    Painter.getInstance().stop();
                }
                if (win instanceof Frame) {
                    this.windowList.remove(win);
                }
                if (win instanceof Dialog || win instanceof Frame) {
                    this.removeWindowDecorations(win);
                }
            }
        }
    }

    public Vector getWindows() {
        return this.windowList;
    }

    public void maximize(Window win) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        win.setSize(screen.width, screen.height);
    }

    public void setMenuBar(Frame frame, DefaultMenuBar menubar) {
        DefaultMenuBar oldmenubar = (DefaultMenuBar)this.menubars.get(frame);
        Point loc = frame.getLocationOnScreen();
        Dimension dim = frame.getSize();
        if (menubar == null && oldmenubar != null) {
            this.menubars.remove(frame);
            Window oldbarwindow = oldmenubar.getBarWindow();
            int dy = oldbarwindow.getSize().height;
            Rectangle d = this.checkBounds(frame, loc.x, loc.y - dy, dim.width, dim.height + dy);
            frame.setBounds(loc.x, loc.y - dy, dim.width, dim.height + dy);
            oldbarwindow.setVisible(false);
        } else if (menubar != null && oldmenubar == null) {
            this.menubars.put(frame, menubar);
            Window bar = menubar.getBarWindow();
            int dy = bar.getPreferredSize().height;
            frame.setBounds(loc.x, loc.y + dy, dim.width, dim.height - dy);
            bar.setBounds(loc.x, loc.y, dim.width, dy);
            bar.setVisible(frame.isVisible());
        } else {
            this.setMenuBar(frame, null);
            this.setMenuBar(frame, menubar);
        }
    }

    private void addWindowDecorations(Window win) {
        Decoration decoration = new Decoration();
        decoration.top = new TitleWindow(win);
        decoration.bottom = new DecorationWindow();
        decoration.left = new DecorationWindow();
        decoration.right = new DecorationWindow();
        this.decorations.put(win, decoration);
    }

    private void removeWindowDecorations(Window win) {
        Decoration decoration = (Decoration)this.decorations.get(win);
        if (decoration != null) {
            decoration.top.dispose();
            decoration.bottom.dispose();
            decoration.left.dispose();
            decoration.right.dispose();
            this.decorations.remove(win);
        }
    }

    private Rectangle updateWindow(Window win, int x, int y, int w, int h) {
        Decoration decoration = (Decoration)this.decorations.get(win);
        int dy = 0;
        DefaultMenuBar menubar = (DefaultMenuBar)this.menubars.get(win);
        if (menubar != null) {
            dy = menubar.getBarWindow().getPreferredSize().height;
            menubar.getBarWindow().setBounds(x, y - dy, w, dy);
        }
        if (decoration != null) {
            decoration.top.setBounds(x - 1, y - 16 - dy, w + 2, 16);
            decoration.bottom.setBounds(x - 1, y + h, w + 2, 1);
            decoration.left.setBounds(x - 1, y - dy, 1, h + dy);
            decoration.right.setBounds(x + w, y - dy, 1, h + dy);
        }
        return new Rectangle(x, y, w, h);
    }

    private class Decoration {
        public TitleWindow top;
        public DecorationWindow bottom;
        public DecorationWindow left;
        public DecorationWindow right;

        private Decoration() {
        }
    }
}

