/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rudolph;

import java.lang.ref.SoftReference;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ImageCache {
    private static final int DEFAULT_CAPACITY = 101;
    protected int[] keys;
    protected SoftReference[] values;
    private float loadFactor;
    private int threshold;
    private transient int capacity;
    private transient int occupancy;
    private transient int modCount;

    private final void resize(int newsize) {
        int oldsize = this.capacity;
        int[] oldkeys = this.keys;
        SoftReference[] oldvalues = this.values;
        int[] newkeys = new int[newsize];
        SoftReference[] newvalues = new SoftReference[newsize];
        this.capacity = newsize;
        this.threshold = (int)((float)this.capacity * this.loadFactor);
        this.occupancy = 0;
        this.keys = newkeys;
        this.values = newvalues;
        int oldindex = 0;
        while (oldindex < oldsize) {
            int key = oldkeys[oldindex];
            if (key != 0) {
                this.putref(key, oldvalues[oldindex]);
            }
            ++oldindex;
        }
    }

    protected int firstBusySlot(int i) {
        if (i < 0 || i >= this.capacity || this.keys == null) {
            return -1;
        }
        int j = i;
        while (j < this.capacity) {
            if (this.keys[j] != 0) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    private final int probe(int hashcode, int sequence) {
        int rehash = (hashcode - sequence) % this.capacity;
        if (rehash < 0) {
            rehash += this.capacity;
        }
        return rehash;
    }

    private final void deleteSlot(int slotIndex) {
        --this.occupancy;
        int current = slotIndex;
        while (true) {
            this.keys[current] = 0;
            int vacant = current;
            boolean happy = true;
            while (happy) {
                int n = current = current == 0 ? this.capacity - 1 : current - 1;
                if (this.keys[current] == 0) {
                    return;
                }
                int home = this.probe(this.keys[current], 0);
                int distance1 = current <= home ? home - current : this.capacity + home - current;
                int distance2 = current <= vacant ? vacant - current : this.capacity + vacant - current;
                boolean bl = false;
                if (distance1 >= distance2) continue;
                bl = happy = true;
            }
            this.keys[vacant] = this.keys[current];
            this.values[vacant] = this.values[current];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object get(int key) {
        if (key == 0) {
            return null;
        }
        ImageCache imageCache = this;
        synchronized (imageCache) {
            if (this.keys == null) {
                return null;
            }
            int j = 0;
            int hash = key;
            int i;
            while (this.keys[i = this.probe(hash, j)] != 0) {
                if (key == this.keys[i]) {
                    return this.values[i].get();
                }
                ++j;
            }
            return null;
        }
    }

    private final int checkSize(int direction) {
        float targetsquared = this.loadFactor * this.loadFactor;
        float current = this.capacity > 0 ? (float)this.occupancy / (float)this.capacity : 1.0f;
        float currentsquared = current * current;
        if (direction >= 0 && currentsquared < this.loadFactor || direction <= 0 && targetsquared > current) {
            return 0;
        }
        int newsize = (int)((float)this.occupancy / this.loadFactor);
        if (newsize < this.occupancy + 2) {
            newsize = this.occupancy + 2;
        }
        if (direction >= 0 && newsize <= this.capacity) {
            newsize = 0;
        }
        if (direction <= 0 && newsize >= this.capacity) {
            newsize = 0;
        }
        return newsize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object putref(int key, SoftReference newvalue) throws NullPointerException {
        if (key == 0 || newvalue == null) {
            throw new NullPointerException();
        }
        int j = 0;
        int hashcode = key;
        ImageCache imageCache = this;
        synchronized (imageCache) {
            if (this.keys == null) {
                this.keys = new int[101];
                this.values = new SoftReference[101];
                this.capacity = 101;
                this.threshold = (int)((float)this.capacity * this.loadFactor);
            }
            while (true) {
                int i;
                if (this.keys[i = this.probe(hashcode, j)] == 0) {
                    this.keys[i] = key;
                    this.values[i] = newvalue;
                    ++this.occupancy;
                    int newsize = this.checkSize(1);
                    if (newsize != 0) {
                        this.resize(newsize);
                    }
                    return null;
                }
                if (key == this.keys[i]) {
                    SoftReference oldvalue = this.values[i];
                    this.values[i] = newvalue;
                    return oldvalue;
                }
                ++j;
            }
        }
    }

    public Object put(int key, Object newvalue) throws NullPointerException {
        return this.putref(key, new SoftReference(newvalue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object remove(int key) {
        if (key == 0) {
            return null;
        }
        int j = 0;
        int hashcode = key;
        ImageCache imageCache = this;
        synchronized (imageCache) {
            if (this.keys == null) {
                return null;
            }
            int i;
            while (this.keys[i = this.probe(hashcode, j)] != 0) {
                if (key == this.keys[i]) {
                    Object oldvalue = this.values[i].get();
                    this.deleteSlot(i);
                    int newsize = this.checkSize(-1);
                    if (newsize != 0) {
                        this.resize(newsize);
                    }
                    return oldvalue;
                }
                ++j;
            }
            return null;
        }
    }

    public void clear() {
        if (this.keys != null) {
            int idx = 0;
            while (idx < this.capacity) {
                if (this.keys[idx] != 0) {
                    this.deleteSlot(idx);
                }
                ++idx;
            }
            this.occupancy = 0;
        }
    }

    private final /* synthetic */ void this() {
        this.modCount = 0;
    }

    public ImageCache(int initialCapacity, float loadFactor) throws IllegalArgumentException {
        this.this();
        if (initialCapacity < 0 || loadFactor <= 0.0f) {
            throw new IllegalArgumentException();
        }
        if (loadFactor > 1.0f) {
            loadFactor = 0.75f;
        }
        this.capacity = initialCapacity < 5 ? 5 : initialCapacity;
        this.keys = new int[this.capacity];
        this.values = new SoftReference[this.capacity];
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)this.capacity * loadFactor);
        this.occupancy = 0;
    }

    public ImageCache(int initialCapacity) throws IllegalArgumentException {
        this(initialCapacity, 0.75f);
    }

    public ImageCache() {
        this(101, 0.75f);
    }
}

