/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rudolph;

import com.acunia.wonka.rudolph.GIFAnimator;
import com.acunia.wonka.rudolph.GIFFrame;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.WeakHashMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GIFImageSource
implements ImageProducer {
    private static int NEXT_FRAME_NONE = 0;
    private static int NEXT_FRAME_REPAINT = 0;
    private static int NEXT_FRAME_UPDATE = Integer.MIN_VALUE;
    private Vector consumers;
    private Hashtable properties;
    private ColorModel colorModel;
    protected Vector frames;
    protected byte[] pixels;
    protected int height;
    protected int width;
    protected int next_event;
    private GIFFrame current_frame;
    private int counter;
    private byte background;

    private final native void readImage(byte[] var1);

    public void addConsumer(ImageConsumer consumer) {
        if (!this.consumers.contains(consumer)) {
            this.consumers.add(consumer);
        }
    }

    public boolean isConsumer(ImageConsumer consumer) {
        return this.consumers.contains(consumer);
    }

    public void removeConsumer(ImageConsumer consumer) {
        this.consumers.remove(consumer);
    }

    public void requestTopDownLeftRightResend(ImageConsumer consumer) {
    }

    private final native void copyFrame(GIFFrame var1);

    private final int getNextFrame() {
        boolean newpixels = false;
        int result = NEXT_FRAME_REPAINT;
        if (this.pixels == null) {
            this.pixels = new byte[this.width * this.height];
            newpixels = true;
        }
        if (this.frames == null) {
            return NEXT_FRAME_NONE;
        }
        this.current_frame = (GIFFrame)this.frames.elementAt(this.counter);
        if (newpixels && this.current_frame.transparent != -1) {
            Arrays.fill(this.pixels, (byte)this.current_frame.transparent);
        }
        switch (this.current_frame.disposal) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (this.current_frame.transparent != -1) {
                    Arrays.fill(this.pixels, (byte)this.current_frame.transparent);
                } else {
                    Arrays.fill(this.pixels, this.background);
                }
                result = NEXT_FRAME_UPDATE;
                break;
            }
            case 3: {
                result = NEXT_FRAME_UPDATE;
                break;
            }
        }
        this.copyFrame(this.current_frame);
        ++this.counter;
        if (this.counter == this.frames.size()) {
            this.counter = 0;
        }
        return result;
    }

    public synchronized void startProduction(ImageConsumer consumer) {
        if (this.frames.size() > 1) {
            GIFAnimator gifAnimator = GIFAnimator.getInstance();
            gifAnimator.registerGIF(this, consumer);
        }
        this.getNextFrame();
        if (consumer != null) {
            this.addConsumer(consumer);
        }
        ColorModel model = this.current_frame.colorModel != null ? this.current_frame.colorModel : this.colorModel;
        Iterator iter = this.consumers.iterator();
        byte[] newpixels = new byte[this.width * this.height];
        while (iter.hasNext()) {
            consumer = (ImageConsumer)iter.next();
            consumer.setDimensions(this.width, this.height);
            consumer.setProperties(this.properties);
            consumer.setColorModel(model);
            System.arraycopy(this.pixels, 0, newpixels, 0, this.width * this.height);
            consumer.setPixels(0, 0, this.width, this.height, model, newpixels, 0, this.width);
            consumer.imageComplete(8);
        }
        this.consumers = new Vector();
    }

    public synchronized boolean produceNextFrame(WeakHashMap consumers, int current_tick) {
        boolean result = false;
        int update = this.getNextFrame();
        this.next_event = current_tick + this.current_frame.delay / 4;
        Iterator iter = consumers.keySet().iterator();
        byte[] newpixels = new byte[this.width];
        while (iter.hasNext()) {
            ImageConsumer consumer = (ImageConsumer)iter.next();
            if (consumer == null) continue;
            result = true;
            consumer.setDimensions(this.width, this.height);
            consumer.setProperties(this.properties);
            consumer.setColorModel(this.colorModel);
            int i = 0;
            while (i < this.height) {
                System.arraycopy(this.pixels, i * this.width, newpixels, 0, this.width);
                consumer.setPixels(0, i, this.width, 1, this.colorModel, newpixels, 0, this.width);
                ++i;
            }
            consumer.imageComplete(2 | update);
        }
        return result;
    }

    private final void addFrame(GIFFrame frame) {
        if (this.frames == null) {
            this.frames = new Vector();
        }
        this.frames.add(frame);
    }

    boolean isAnimated() {
        boolean bl = false;
        if (this.frames.size() > 1) {
            bl = true;
        }
        return bl;
    }

    private final /* synthetic */ void this() {
        this.counter = 0;
    }

    public GIFImageSource(byte[] data) {
        this.this();
        this.readImage(data);
        this.consumers = new Vector();
    }
}

