/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rudolph;

import java.awt.Window;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import wonka.vm.Wonka;

public final class Dispatcher
implements Runnable {
    private static Dispatcher theDispatcher;
    private int sleep_millis = 1;
    private int priority = 5;
    private boolean keepOnGoing = false;
    private Thread thread = null;
    private Window root = null;
    static /* synthetic */ Class class$com$acunia$wonka$rudolph$Dispatcher;

    private static String getMouseDevice() {
        String filename = Wonka.getProperty("wonka.device.config", "/system/device.config");
        InputStream s = (class$com$acunia$wonka$rudolph$Dispatcher == null ? (class$com$acunia$wonka$rudolph$Dispatcher = Dispatcher.class$("com.acunia.wonka.rudolph.Dispatcher")) : class$com$acunia$wonka$rudolph$Dispatcher).getResourceAsStream(filename);
        BufferedReader r = new BufferedReader(new InputStreamReader(s));
        try {
            String line;
            while ((line = r.readLine()) != null) {
                int start;
                while ((start = line.indexOf("  ")) != -1) {
                    line = line.substring(0, start) + line.substring(start + 1);
                }
                while ((start = line.indexOf("( ")) != -1) {
                    int end = line.indexOf(")", start + 2);
                    if (end > start) {
                        line = line.substring(0, start) + line.substring(end + 1);
                        continue;
                    }
                    line = line.substring(0, start);
                }
                StringTokenizer t = new StringTokenizer(line);
                while (t.hasMoreTokens()) {
                    String command = t.nextToken();
                    if (!command.toLowerCase().equals("attach-mouse-device")) continue;
                    try {
                        String family = t.nextToken();
                        String number = t.nextToken();
                        String path = t.nextToken();
                        return path;
                    }
                    catch (NoSuchElementException e) {
                        System.err.println("attach-mouse-device : syntax is attach-mouse-device <family> <number> <path>");
                    }
                    catch (NumberFormatException nfe) {
                        System.err.println("attach-mouse-device : illegal device number");
                    }
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return Wonka.getProperty("wonka.default.mouse.device", "/dev/ts");
    }

    public Dispatcher(Window root) {
        this.root = root;
    }

    public static synchronized Dispatcher getMainDispatcher() {
        if (theDispatcher == null) {
            theDispatcher = new Dispatcher(null);
        }
        return theDispatcher;
    }

    private static native void init(String var0);

    private static native void shutdown();

    private native void poll(Window var1);

    public void run() {
        while (this.keepOnGoing) {
            try {
                Thread.sleep(this.sleep_millis);
                this.poll(this.root);
            }
            catch (InterruptedException e) {
            }
            catch (Throwable ex) {
                try {
                    ex.printStackTrace();
                }
                catch (Throwable throwable) {}
            }
        }
        this.thread = null;
    }

    public void start() {
        if (!this.keepOnGoing) {
            this.keepOnGoing = true;
            this.thread = new Thread(this, "Rudolph");
            this.thread.setPriority(this.priority);
            this.thread.setDaemon(false);
            this.thread.start();
        }
    }

    public void stop() {
        this.keepOnGoing = false;
    }

    public static boolean isDispatchThread(Thread t) {
        return "Rudolph".equals(t.getName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String mouse_device = Dispatcher.getMouseDevice();
        Dispatcher.init(mouse_device);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                Dispatcher.shutdown();
            }
        });
    }
}

