/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.net.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;

public class FileURLConnection
extends URLConnection {
    public void connect() throws IOException {
        if (this.url.getHost().length() > 0) {
            throw new IOException("file is not on localhost -->" + this.url);
        }
        if (!new File(this.url.getFile()).isFile()) {
            throw new FileNotFoundException("file " + this.url.getFile() + " does not exist or is no file");
        }
        this.connected = true;
    }

    public Permission getPermission() throws IOException {
        return new FilePermission(this.url.getFile(), "read");
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return new FileInputStream(this.url.getFile());
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return new FileOutputStream(this.url.getFile());
    }

    public FileURLConnection(URL url) {
        super(url);
    }
}

