/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.resource;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.TimeZone;
import wonka.vm.Wonka;

public class TimeZoneResourceBundle
extends ResourceBundle {
    private static Hashtable timeZones;
    private static final TimeZone[] THETIMEZONES;

    private static final synchronized void createTimeZones() {
        if (timeZones == null) {
            timeZones = new Hashtable(THETIMEZONES.length * 2);
            int k = 0;
            while (k < THETIMEZONES.length) {
                String id = THETIMEZONES[k].getID();
                timeZones.put(id, THETIMEZONES[k]);
                String aliases = Wonka.getProperty("wonka.timezone." + id + ".aliases");
                if (aliases != null) {
                    StringTokenizer st = new StringTokenizer(aliases, ":");
                    while (st.hasMoreTokens()) {
                        String name = st.nextToken();
                        SimpleTimeZone z = (SimpleTimeZone)THETIMEZONES[k].clone();
                        z.setID(name);
                        timeZones.put(name, z);
                    }
                }
                ++k;
            }
        }
    }

    protected Object handleGetObject(String key) throws MissingResourceException {
        Object o = timeZones.get(key);
        if (o != null) {
            return o;
        }
        throw new MissingResourceException("Oops, resource not found", "TimeZoneResourceBundle", "key");
    }

    public Enumeration getKeys() {
        return timeZones.keys();
    }

    public String[] getKeysArray() {
        int length = timeZones.size();
        String[] keys = new String[length];
        Enumeration e = timeZones.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            keys[i++] = (String)e.nextElement();
        }
        return keys;
    }

    public String[] getKeysArray(int rOffset) {
        int length = timeZones.size();
        String[] keys = new String[length];
        Enumeration e = timeZones.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (rOffset != ((SimpleTimeZone)timeZones.get(s)).getRawOffset()) continue;
            keys[i++] = s;
        }
        String[] okeys = new String[i];
        System.arraycopy(keys, 0, okeys, 0, i);
        return okeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TimeZone getTimeZone(String keyID) {
        SimpleTimeZone simpleTimeZone;
        SimpleTimeZone z;
        block8: {
            z = null;
            Hashtable hashtable = timeZones;
            synchronized (hashtable) {
                z = (SimpleTimeZone)timeZones.get(keyID);
                if (z == null && keyID.length() == 9 && keyID.startsWith("GMT") && keyID.charAt(6) == ':') {
                    char sign_char = keyID.charAt(3);
                    int h10 = Character.digit(keyID.charAt(4), 3);
                    int h1 = Character.digit(keyID.charAt(5), 10);
                    int m10 = Character.digit(keyID.charAt(7), 7);
                    int m1 = Character.digit(keyID.charAt(8), 10);
                    if (h10 >= 0 && h1 >= 0 && m10 >= 0 && m1 >= 0) {
                        int mins = m1 + 10 * (m10 + 6 * (h1 + 10 * h10));
                        if (sign_char == '+') {
                            z = new SimpleTimeZone(60000 * mins, keyID);
                            z.setID(keyID);
                            timeZones.put(keyID, z);
                        } else if (sign_char == '-') {
                            z = new SimpleTimeZone(-60000 * mins, keyID);
                            z.setID(keyID);
                            timeZones.put(keyID, z);
                        }
                    }
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl25 : MonitorExitStatement: MONITOREXIT : var3_3
                if (z != null) break block8;
            }
            simpleTimeZone = (SimpleTimeZone)timeZones.get("GMT");
            return simpleTimeZone;
        }
        simpleTimeZone = z;
        return simpleTimeZone;
    }

    public TimeZoneResourceBundle() {
        if (timeZones == null) {
            TimeZoneResourceBundle.createTimeZones();
        }
    }

    static {
        THETIMEZONES = new TimeZone[]{new SimpleTimeZone(0, "GMT"), new SimpleTimeZone(0, "WET", 2, -1, 1, 3600000, 9, -1, 1, 3600000, 3600000), new SimpleTimeZone(3600000, "ECT", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00, 3600000), new SimpleTimeZone(0x6DDD00, "EET", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00, 3600000), new SimpleTimeZone(-28800000, "PST", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00, 3600000), new SimpleTimeZone(-39600000, "MIT", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00, 3600000), new SimpleTimeZone(-36000000, "CAT", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00, 3600000), new SimpleTimeZone(-32400000, "AST", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00, 3600000), new SimpleTimeZone(-25200000, "MST", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00, 3600000), new SimpleTimeZone(-21600000, "CST", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00, 3600000), new SimpleTimeZone(-18000000, "EST", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00, 3600000), new SimpleTimeZone(-12600000, "NST", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00, 3600000), new SimpleTimeZone(28800000, "CTT", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00, 3600000), new SimpleTimeZone(32400000, "JST", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00, 3600000), new SimpleTimeZone(-25200000, "PNT"), new SimpleTimeZone(-18000000, "IET"), new SimpleTimeZone(-14400000, "PRT"), new SimpleTimeZone(-12600000, "CNT"), new SimpleTimeZone(-10800000, "AGT"), new SimpleTimeZone(-10800000, "BET"), new SimpleTimeZone(-3600000, "HST"), new SimpleTimeZone(0x6DDD00, "ART"), new SimpleTimeZone(10800000, "EAT"), new SimpleTimeZone(12600000, "MET"), new SimpleTimeZone(14400000, "NET"), new SimpleTimeZone(18000000, "PLT"), new SimpleTimeZone(19800000, "IST"), new SimpleTimeZone(21600000, "BST"), new SimpleTimeZone(25200000, "VST"), new SimpleTimeZone(28800000, "CTT"), new SimpleTimeZone(34200000, "ACT"), new SimpleTimeZone(36000000, "AET"), new SimpleTimeZone(39600000, "SST"), new SimpleTimeZone(43200000, "NST"), new SimpleTimeZone(0x6DDD00, "GMT+02:00")};
    }
}

