/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.device.uart;

import com.acunia.device.uart.UART;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.comm.CommDriver;
import javax.comm.CommPort;
import javax.comm.CommPortIdentifier;
import wonka.vm.Wonka;

public class UARTDriver
implements CommDriver {
    private static UARTDriver singleton = null;

    private final void attachSerialDevice(StringTokenizer t) {
        try {
            String family = t.nextToken();
            String number = t.nextToken();
            String path = t.nextToken();
            UARTDriver.attachSerialDevice0(family, Integer.parseInt(number), path);
        }
        catch (NoSuchElementException e) {
            System.err.println("attachSerialDevice : syntax is attach-serial-device <family> <number> <path>");
        }
        catch (NumberFormatException nfe) {
            System.err.println("attachSerialDevice : illegal device number");
        }
    }

    private final void registerSerialDevice(StringTokenizer t) {
        try {
            String name = t.nextToken();
            String family = t.nextToken();
            String number = t.nextToken();
            UARTDriver.registerSerialDevice0(name, family, Integer.parseInt(number));
        }
        catch (NoSuchElementException e) {
            System.err.println("registerSerialDevice : syntax is register-serial-device <name> <family> <number>");
        }
        catch (NumberFormatException nfe) {
            System.err.println("registerSerialDevice : illegal device number");
        }
    }

    private static final native void registerSerialDevice0(String var0, String var1, int var2);

    private static final native void attachSerialDevice0(String var0, int var1, String var2);

    private static final native String firstUARTname();

    private static final native String nextUARTname();

    public void initialize() {
        String portname = UARTDriver.firstUARTname();
        while (portname != null) {
            CommPortIdentifier.addPortName(portname, 1, this);
            portname = UARTDriver.nextUARTname();
        }
    }

    public static synchronized UARTDriver getInstance() {
        if (singleton == null) {
            singleton = new UARTDriver();
        }
        return singleton;
    }

    public CommPort getCommPort(String portName, int portType) throws IllegalArgumentException {
        if (portType == 1) {
            try {
                return new UART(portName);
            }
            catch (IOException ioe) {
                return null;
            }
        }
        throw new IllegalArgumentException();
    }

    /*
     * Unable to fully structure code
     */
    protected UARTDriver() {
        super();
        filename = Wonka.getProperty("wonka.device.config", "/system/device.config");
        s = this.getClass().getResourceAsStream(filename);
        r = new BufferedReader(new InputStreamReader(s));
        try {
            ** GOTO lbl23
            {
                line = line.substring(0, start) + line.substring(start + 1);
                do {
                    if ((start = line.indexOf("  ")) != -1) continue block2;
                    while ((start = line.indexOf("( ")) != -1) {
                        end = line.indexOf(")", start + 2);
                        line = end > start ? line.substring(0, start) + line.substring(end + 1) : line.substring(0, start);
                    }
                    t = new StringTokenizer(line);
                    while (t.hasMoreTokens()) {
                        command = t.nextToken();
                        if (command.toLowerCase().equals("attach-serial-device")) {
                            this.attachSerialDevice(t);
                            continue;
                        }
                        if (!command.toLowerCase().equals("register-serial-device")) continue;
                        this.registerSerialDevice(t);
                    }
lbl23:
                    // 2 sources

                } while ((line = r.readLine()) != null);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

