#!/bin/sh

# Get the full name of the directory containing this script
scriptdir=`/usr/bin/dirname $0`
cd "$scriptdir"
fullscriptdir=`pwd`

# Ask a yes/no question.  First argument is the prompt.
yesnoprompt() {
  if test -n "$1" ; then
    params="-p"
  else
    params=
  fi
  while :
  do
    read $params "$1" input
    case $input in
    y | Y | yes | YES | Yes)
      return 0 ;;
    n | N | no | NO | No)
      return 1 ;;
    esac
    echo "Response unrecognized.  Please answer y/n."
  done
}

# Compute the free and total internal memory
intfree=`df -h /mnt/free | grep /mnt/free | tr -s " " | cut -f4 -d" "`
inttotal=`df -h /mnt/free | grep /mnt/free | tr -s " " | cut -f2 -d" "` 

echo
echo "Items to install:"
echo "  " `../../_xshell/startxshell --xshellversion`
echo "  " `../../sh/launch.sh --preserve-manifest --launcherversion`
echo "  " `../../_xshell/mrxvt/mrxvt -help 2>&1 | head -n 1`
echo
echo "Checking for existing versions..."

# Find the location of the default xshell
location=`../../sh/launch.sh 2>/dev/null --preserve-manifest --location`

# If the find succeeded,
if test $? -eq 0 ; then
  # Get the xshell version
  version=`"$location/startxshell" --xshellversion`
  echo "Warning: The following version of xshell has been found."
  echo "$location: $version"
  echo
  echo "It is recommended that you abort installation and uninstall."
  yesnoprompt "Abort installation? (y/n)+<Enter>: "
  if test $? -eq 0 ; then
    echo "Installation aborted."
    exit 1
  fi
else 
  echo "No existing versions of xshell interface 0.5.0 or greater found."
fi

echo 
echo "Installing xshell to internal memory is recommended since it ensures"
echo "that it will run quickly and remain available without memory cards"
echo "installed.  Free internal memory is $intfree of $inttotal." 
echo "This installation of xshell and mrxvt will occupy about 2.0M."
echo
yesnoprompt "Continue? (y/n)+<Enter>: "
if test $? -eq 1 ; then
  echo "Installation aborted."
  exit 1
fi

echo "Copying xshell to internal memory.  (/mnt/free/_xshell)"
cp -R ../../_xshell /mnt/free/
echo "Creating configuration file.        ($HOME/.xshell)"
echo "location=/mnt/free/_xshell" > $HOME/.xshell
chmod u+x $HOME/.xshell
echo "Creating shortcut to command shell. (/mnt/free/sh)"
cp -R ../../sh /mnt/free
if test -d /usr/local/programs ; then
  echo "Creating additional shortcut.     (/usr/local/programs)"
  cp -R ../../sh /usr/local/programs
fi
if test -d /usr/local/programs/Uninstall ; then
  echo "Creating uninstaller.             (/usr/local/programs/Uninstall)"
  mkdir /usr/local/programs/Uninstall/sh
  cp -R ../50_uninstall/* /usr/local/programs/Uninstall/sh/
  cp ../../sh/launch.sh /usr/local/programs/Uninstall/sh/
  cp ../../sh/shell.png /usr/local/programs/Uninstall/_shell.png

  # We need to rewrite the run.sh script for the uninstaller.  
  cat > /usr/local/programs/Uninstall/sh/run.sh <<'END'
    dir=`/usr/bin/dirname $0`
    "$dir/launch.sh" --hold --execute "$dir/uninstaller.sh"
END
  # End of the new run.sh

fi

echo "Installation complete."
