/*
 * Decompiled with CFR 0.152.
 */
package uk.co.flamingpenguin.jewel.cli;

import uk.co.flamingpenguin.jewel.cli.CommandLineInterface;
import uk.co.flamingpenguin.jewel.cli.UnparsedSpecificationImpl;

class CliSpecificationImpl {
    private final String m_message;

    public CliSpecificationImpl(CommandLineInterface cliSpecification, UnparsedSpecificationImpl unparsedSpecification, boolean mandatoryOptions) {
        if (cliSpecification == null && unparsedSpecification == null) {
            this.m_message = "The options available are:";
        } else {
            StringBuilder message = new StringBuilder("Usage: ");
            if (cliSpecification != null && !this.nullOrBlank(cliSpecification.application())) {
                message.append(String.format("%s ", cliSpecification.application().trim()));
            }
            if (!mandatoryOptions) {
                message.append("[");
            }
            message.append("options");
            if (!mandatoryOptions) {
                message.append("]");
            }
            message.append(" ");
            if (unparsedSpecification != null) {
                String unparsedName = !this.nullOrBlank(unparsedSpecification.getLongName()) ? unparsedSpecification.getLongName() : "ARGUMENTS";
                message.append(unparsedName);
                if (unparsedSpecification.isMultiValued()) {
                    message.append("...");
                }
            }
            this.m_message = message.toString().trim();
        }
    }

    private boolean nullOrBlank(String string) {
        return string == null || string.trim().equals("");
    }

    public String toString() {
        return this.m_message;
    }
}

