/*
 * Decompiled with CFR 0.152.
 */
package de.netseeker.cextra;

import de.netseeker.cextra.Parameterizable;
import de.netseeker.cextra.SiteCaputurer;
import de.netseeker.cextra.profile.IProfile;
import de.netseeker.cextra.profile.ProfileFactory;
import de.netseeker.cextra.regex.IRegExReplacer;
import de.netseeker.cextra.regex.MetaInfoReplacer;
import de.netseeker.cextra.tags.PreTag;
import de.netseeker.cextra.util.IOFacade;
import de.netseeker.cextra.util.TidyFacade;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.HashSet;
import java.util.Set;
import org.htmlparser.Parser;
import org.htmlparser.PrototypicalNodeFactory;
import org.htmlparser.tags.LinkTag;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.htmlparser.util.SimpleNodeIterator;
import org.htmlparser.visitors.NodeVisitor;
import uk.co.flamingpenguin.jewel.cli.ArgumentValidationException;
import uk.co.flamingpenguin.jewel.cli.CliFactory;

public class Cextra {
    private Parameterizable arguments;
    private IProfile profile;
    private Set<URI> processedLinks = new HashSet<URI>();
    private PrototypicalNodeFactory nodeFactory = new PrototypicalNodeFactory();
    private String absoluteOutputPath = null;

    public static void main(String[] stringArray) {
        try {
            Cextra cextra = new Cextra(CliFactory.parseArguments(Parameterizable.class, stringArray));
            cextra.createEBook();
        }
        catch (ArgumentValidationException argumentValidationException) {
            System.out.println(argumentValidationException.getMessage());
            System.out.println("");
            System.out.println("Use java -jar cextra.jar -h to get a full list of options");
        }
    }

    private Cextra(Parameterizable parameterizable) {
        if (!parameterizable.getTarget().exists() && !parameterizable.getTarget().mkdirs()) {
            throw new RuntimeException("Creation of directory " + parameterizable.getTarget().getPath() + "failed!");
        }
        this.arguments = parameterizable;
        this.absoluteOutputPath = parameterizable.getTarget().getAbsolutePath().replaceAll("\\\\", "/");
        this.profile = ProfileFactory.createProfile(parameterizable.getProfile());
        this.nodeFactory.registerTag(new PreTag());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEBook() {
        Serializable serializable;
        String string = null;
        SiteCaputurer siteCaputurer = new SiteCaputurer();
        siteCaputurer.setCaptureResources(true);
        try {
            serializable = new NodeList();
            LinkTag linkTag = new LinkTag();
            linkTag.setLink(this.arguments.getUrl().toString());
            ((NodeList)serializable).add(linkTag);
            StringBuilder stringBuilder = new StringBuilder();
            this.capture(siteCaputurer, (NodeList)serializable, stringBuilder, this.arguments.getTarget());
            String string2 = IOFacade.resourceToString(Cextra.class.getResource("ebook.xhtml"), false);
            IRegExReplacer iRegExReplacer = new MetaInfoReplacer(this.arguments);
            string2 = iRegExReplacer.replace(string2);
            if (this.arguments.getDebug()) {
                IOFacade.resourceToFile(stringBuilder.toString(), new File(this.arguments.getTarget(), "debug_pre_replace.xhtml"));
            }
            string2 = (iRegExReplacer = this.profile.getContentReplacer()) != null ? string2.replaceFirst("<!-- CONTENT -->", iRegExReplacer.replace(stringBuilder.toString())) : string2.replaceFirst("<!-- CONTENT -->", stringBuilder.toString());
            if (this.arguments.getDebug()) {
                IOFacade.resourceToFile(string2, new File(this.arguments.getTarget(), "debug_pre_tidy.xhtml"));
            }
            string2 = TidyFacade.tidy(string2, this.arguments.getDebug());
            IOFacade.resourceToFile(string2, new File(this.arguments.getTarget(), "ebook.xhtml"));
            IOFacade.resourceToFile(Cextra.class.getResource("ebook.css"), new File(this.arguments.getTarget(), "ebook.css"), true);
            string = "eBook download finished";
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            string = "eBook download failed";
        }
        finally {
            serializable = new File(this.arguments.getTarget(), "index.html");
            if (((File)serializable).exists()) {
                ((File)serializable).delete();
            }
        }
        System.out.println("");
        System.out.println("-----------------------");
        System.out.println(string);
        System.out.println("-----------------------");
    }

    private void capture(SiteCaputurer siteCaputurer, NodeList nodeList, StringBuilder stringBuilder, File file) throws ParserException, IOException {
        Parser parser = new Parser();
        parser.setNodeFactory(this.nodeFactory);
        SimpleNodeIterator simpleNodeIterator = nodeList.elements();
        while (simpleNodeIterator.hasMoreNodes()) {
            LinkTag linkTag = (LinkTag)simpleNodeIterator.nextNode();
            URL uRL = new URL(linkTag.getLink().replaceAll("#gb_found", ""));
            String string = uRL.getFile();
            if (string.contains(this.absoluteOutputPath + "/index.html")) {
                string = string.replace(this.absoluteOutputPath + "/index.html", "").replaceAll("//", "/").replaceAll("&amp;", "&");
            }
            URL uRL2 = new URL(this.arguments.getUrl().getProtocol(), this.arguments.getUrl().getHost(), string);
            try {
                if (!this.processedLinks.contains(uRL2.toURI())) {
                    this.processedLinks.add(uRL2.toURI());
                    siteCaputurer.setSource(uRL2.toString());
                    siteCaputurer.setTarget(file.getPath());
                    siteCaputurer.capture();
                    File file2 = new File(file.getPath() + "/index.html");
                    if (file2.exists()) {
                        parser.setURL(file2.getPath());
                        parser.setEncoding("UTF-8");
                        NodeList nodeList2 = parser.parse(this.profile.getNavigationFilter());
                        parser.reset();
                        boolean bl = false;
                        if (!uRL2.equals(this.arguments.getUrl()) || nodeList2 == null || nodeList2.size() == 0) {
                            parser.setNodeFactory(this.nodeFactory);
                            byte[] byArray = IOFacade.fileToBytes(file2);
                            CharsetDecoder charsetDecoder = Charset.forName("UTF-8").newDecoder();
                            charsetDecoder.onMalformedInput(CodingErrorAction.REPLACE);
                            charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
                            String string2 = charsetDecoder.decode(ByteBuffer.wrap(byArray)).toString();
                            parser.setInputHTML(string2);
                            parser.setEncoding("UTF-8");
                            NodeList nodeList3 = parser.parse(this.profile.getContentFilter());
                            if (nodeList3 != null && nodeList3.size() > 0) {
                                if (this.profile.getContentVisitors() != null) {
                                    for (NodeVisitor nodeVisitor : this.profile.getContentVisitors()) {
                                        nodeList3.visitAllNodesWith(nodeVisitor);
                                    }
                                }
                                stringBuilder.append(nodeList3.toHtml());
                                stringBuilder.append("\n");
                                bl = true;
                            }
                        }
                        if (nodeList2 != null && nodeList2.size() > 0) {
                            int n = this.profile.getCurrentHeading();
                            if (!this.profile.isOneLevelNavigation() && n <= 3 && bl) {
                                this.profile.setCurrentHeading(n + 1);
                            }
                            this.capture(siteCaputurer, nodeList2, stringBuilder, file);
                            if (!this.profile.isOneLevelNavigation() && n <= 3 && bl) {
                                this.profile.setCurrentHeading(this.profile.getCurrentHeading() - 1);
                            }
                        }
                    } else {
                        System.err.println("tmp file " + file2.getPath() + " does not exist! URL: " + uRL2.toString());
                    }
                    parser.reset();
                    continue;
                }
                System.out.println("skipping " + uRL2.toString() + ". already spidered...");
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
        }
    }
}

